/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils;

import filenet.vw.api.VWException;
import filenet.vw.idm.toolkit.IVWIDMFactoryProperties;
import filenet.vw.idm.toolkit.VWIDMBaseFactory;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;

public class VWUrlConnection {
    public static final String ACTION_KEY = "action";
    public static final String LOGON_VALUE = "logon";
    public static final String LOGOFF_VALUE = "logoff";
    public static final String ROUTER_URL_VALUE = "routerURL";
    public static final String PING_VALUE = "ping";
    public static final String TOKEN_VALUE = "token";
    private String m_appServerUrl = null;
    private String m_sessionId = null;

    public VWUrlConnection(String appServerUrl) throws VWException {
        try {
            URL url = new URL(appServerUrl);
            this.m_appServerUrl = appServerUrl;
            IVWIDMFactoryProperties factoryProperties = VWIDMBaseFactory.instance().getProperties();
            this.m_sessionId = (String)factoryProperties.getProperty("sessionId");
        }
        catch (MalformedURLException ex) {
            throw new VWException("vw.idm.toolkit.VWUrlConnection.invalidURL", "Invalid HTTP URL. {0}", ex.getLocalizedMessage());
        }
        catch (Exception ex) {
            throw new VWException("vw.idm.toolkit.VWUrlConnection.genericError", "An error occurred. {0}", ex.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String sendCommand(String key, String value) throws VWException {
        String urlString = "";
        URL url = null;
        StringBuffer buffer = new StringBuffer();
        if (this.m_appServerUrl == null) {
            throw new VWException("vw.idm.toolkit.VWUrlConnection.nullURL", "null HTTP URL.");
        }
        try {
            urlString = key != null && key.length() > 0 ? this.m_appServerUrl + "?" + key + "=" + value : this.m_appServerUrl;
            url = new URL(urlString);
        }
        catch (MalformedURLException ex) {
            throw new VWException("vw.idm.toolkit.VWUrlConnection.invalidURL", "Invalid HTTP URL. {0}", ex.getLocalizedMessage());
        }
        try {
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            if (this.m_sessionId != null) {
                connection.setRequestProperty("Cookie", this.m_sessionId);
            }
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                String line = reader.readLine();
                while (line != null) {
                    buffer.append(line);
                    line = reader.readLine();
                }
            }
            catch (EOFException eofEx) {
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
        catch (Exception ex) {
            throw new VWException("vw.idm.toolkit.VWUrlConnection.httpConnectionFailed", "Failed creating HTTP connection. {0}", ex.getLocalizedMessage());
        }
        return this.cleanUpString(buffer.toString());
    }

    private String cleanUpString(String inputString) {
        char charLF = '\n';
        char charCR = '\r';
        if (inputString == null) {
            return null;
        }
        if ((inputString = inputString.trim()).length() == 0) {
            return inputString;
        }
        if (inputString.charAt(inputString.length() - 1) == charLF) {
            inputString = inputString.substring(0, inputString.length() - 1);
        }
        if (inputString.length() == 0) {
            return inputString;
        }
        if (inputString.charAt(inputString.length() - 1) == charCR) {
            inputString = inputString.substring(0, inputString.length() - 1);
        }
        return inputString;
    }
}

